/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;

public class StructureWorld {
    private Map<ChunkPos, Part> parts = Maps.newHashMap();
    private ChunkPos lastPos;
    private Part lastPart;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public StructureWorld() {
    }

    public StructureWorld(CompoundNBT tag) {
        this.minX = tag.func_74762_e("minX");
        this.maxX = tag.func_74762_e("maxX");
        this.minY = tag.func_74762_e("minY");
        this.maxY = tag.func_74762_e("maxY");
        this.minZ = tag.func_74762_e("minZ");
        this.maxZ = tag.func_74762_e("maxZ");
        ListNBT map = tag.func_150295_c("parts", 10);
        map.forEach(element -> {
            CompoundNBT compound = (CompoundNBT)element;
            Part part = new Part(compound);
            int x = compound.func_74762_e("x");
            int z = compound.func_74762_e("z");
            this.parts.put(new ChunkPos(x, z), part);
        });
    }

    public void setBlock(BlockPos pos, BlockState state) {
        ChunkPos cPos = new ChunkPos(pos);
        if (cPos.equals((Object)this.lastPos)) {
            this.lastPart.addBlock(pos, state);
            return;
        }
        Part part = this.parts.get(cPos);
        if (part == null) {
            part = new Part();
            this.parts.put(cPos, part);
            if (cPos.field_77276_a < this.minX) {
                this.minX = cPos.field_77276_a;
            }
            if (cPos.field_77276_a > this.maxX) {
                this.maxX = cPos.field_77276_a;
            }
            if (cPos.field_77275_b < this.minZ) {
                this.minZ = cPos.field_77275_b;
            }
            if (cPos.field_77275_b > this.maxZ) {
                this.maxZ = cPos.field_77275_b;
            }
        }
        if (pos.func_177956_o() < this.minY) {
            this.minY = pos.func_177956_o();
        }
        if (pos.func_177956_o() > this.maxY) {
            this.maxY = pos.func_177956_o();
        }
        part.addBlock(pos, state);
        this.lastPos = cPos;
        this.lastPart = part;
    }

    public boolean placeChunk(ISeedReader world, ChunkPos chunkPos) {
        Part part = this.parts.get(chunkPos);
        if (part != null) {
            IChunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
            part.placeChunk(chunk);
            return true;
        }
        return false;
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("minX", this.minX);
        tag.func_74768_a("maxX", this.maxX);
        tag.func_74768_a("minY", this.minY);
        tag.func_74768_a("maxY", this.maxY);
        tag.func_74768_a("minZ", this.minZ);
        tag.func_74768_a("maxZ", this.maxZ);
        ListNBT map = new ListNBT();
        tag.func_218657_a("parts", (INBT)map);
        this.parts.forEach((pos, part) -> map.add((Object)part.toNBT(pos.field_77276_a, pos.field_77275_b)));
        return tag;
    }

    public MutableBoundingBox getBounds() {
        if (this.minX == Integer.MAX_VALUE || this.maxX == Integer.MIN_VALUE || this.minZ == Integer.MAX_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return MutableBoundingBox.func_78887_a();
        }
        return new MutableBoundingBox(this.minX << 4, this.minY, this.minZ << 4, this.maxX << 4 | 0xF, this.maxY, this.maxZ << 4 | 0xF);
    }

    private static final class Part {
        Map<BlockPos, BlockState> blocks = Maps.newHashMap();

        public Part() {
        }

        public Part(CompoundNBT tag) {
            ListNBT map = tag.func_150295_c("blocks", 10);
            ListNBT map2 = tag.func_150295_c("states", 10);
            BlockState[] states = new BlockState[map2.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)map2.get(i)));
            }
            map.forEach(element -> {
                CompoundNBT block = (CompoundNBT)element;
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)block.func_74775_l("pos"));
                int stateID = block.func_74762_e("state");
                BlockState state = stateID < states.length ? states[stateID] : Block.func_196257_b((int)stateID);
                this.blocks.put(pos, state);
            });
        }

        void addBlock(BlockPos pos, BlockState state) {
            BlockPos inner = new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
            this.blocks.put(inner, state);
        }

        void placeChunk(IChunk chunk) {
            this.blocks.forEach((pos, state) -> chunk.func_177436_a(pos, state, false));
        }

        CompoundNBT toNBT(int x, int z) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("x", x);
            tag.func_74768_a("z", z);
            ListNBT map = new ListNBT();
            tag.func_218657_a("blocks", (INBT)map);
            ListNBT stateMap = new ListNBT();
            tag.func_218657_a("states", (INBT)stateMap);
            int[] id = new int[1];
            HashMap states = Maps.newHashMap();
            this.blocks.forEach((pos, state) -> {
                int stateID = states.getOrDefault(states, -1);
                if (stateID < 0) {
                    int n = id[0];
                    id[0] = n + 1;
                    stateID = n;
                    states.put(state, stateID);
                    stateMap.add((Object)NBTUtil.func_190009_a((BlockState)state));
                }
                CompoundNBT block = new CompoundNBT();
                block.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                block.func_74768_a("state", stateID);
                map.add((Object)block);
            });
            return tag;
        }
    }
}

